<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Classificação por Estrelas</title>
    <style>
        .star-rating {
            display: inline-block;
            direction: rtl; /* Inverter a direção das estrelas */
            unicode-bidi: bidi-override; /* Manter a direção do texto das estrelas */
        }

        .star {
            font-size: 2em;
            color: gray;
            cursor: pointer;
            transition: color 0.2s;
        }

        .star:hover,
        .star:hover ~ .star {
            color: gold;
        }

        .star.selected {
            color: gold;
        }
    </style>
</head>
<body>
    <div class="star-rating">
        <span class="star" data-value="5">&#9733;</span>
        <span class="star" data-value="4">&#9733;</span>
        <span class="star" data-value="3">&#9733;</span>
        <span class="star" data-value="2">&#9733;</span>
        <span class="star" data-value="1">&#9733;</span>
    </div>
    <button id="submit-rating">Enviar Classificação</button>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const stars = document.querySelectorAll(".star");
            let rating = 0;

            stars.forEach(star => {
                star.addEventListener("mouseover", function() {
                    highlightStars(star.getAttribute("data-value"));
                });

                star.addEventListener("mouseout", function() {
                    resetStars();
                });

                star.addEventListener("click", function() {
                    rating = star.getAttribute("data-value");
                    selectStars(rating);
                });
            });

            document.getElementById("submit-rating").addEventListener("click", function() {
                if (rating > 0) {
                    alert(`Você classificou com ${rating} estrela(s).`);
                } else {
                    alert("Por favor, selecione uma classificação.");
                }
            });

            function highlightStars(rating) {
                stars.forEach(star => {
                    if (star.getAttribute("data-value") <= rating) {
                        star.classList.add("highlight");
                    } else {
                        star.classList.remove("highlight");
                    }
                });
            }

            function resetStars() {
                stars.forEach(star => {
                    star.classList.remove("highlight");
                });
            }

            function selectStars(rating) {
                stars.forEach(star => {
                    if (star.getAttribute("data-value") <= rating) {
                        star.classList.add("selected");
                    } else {
                        star.classList.remove("selected");
                    }
                });
            }
        });
    </script>
</body>
</html>
